using System;
using System.Collections;

namespace stjo.net.demos.FulltextKeywordsSearch
{
	/// <summary>
	/// Summary description for Class.
	/// </summary>
	public class Strings : CollectionBase	{

		public String this[ int index ]	{
			get	{
				return( (string) List[index] );
			}
			set	{
				List[index] = value;
			}
		}

		public int Add( string value )	{
			return( List.Add( value ) );
		}

		public int IndexOf( string value )	{
			return( List.IndexOf( value ) );
		}

		public void Insert( int index, string value )	{
			List.Insert( index, value );
		}

		public void Remove( string value )	{
			List.Remove( value );
		}

		public bool Contains( string value )	{
			return( List.Contains( value ) );
		}

		protected override void OnInsert( int index, Object value )	{
			if ( value.GetType() != Type.GetType("System.String") )
				throw new ArgumentException( "value must be of type String.", "value" );
		}

		protected override void OnRemove( int index, Object value )	{
			if ( value.GetType() != Type.GetType("System.String") )
				throw new ArgumentException( "value must be of type String.", "value" );
		}

		protected override void OnSet( int index, Object oldValue, Object newValue )	{
			if ( newValue.GetType() != Type.GetType("System.String") )
				throw new ArgumentException( "newValue must be of type String.", "newValue" );
		}

		protected override void OnValidate( Object value )	{
			if ( value.GetType() != Type.GetType("System.String") )
				throw new ArgumentException( "value must be of type String." );
		}
}


}
